/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.splitter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.storageengine.load.splitter.AlignedChunkData;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.chunk.ValueChunkWriter;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.apache.tsfile.write.writer.TsFileIOWriter;

public class BatchedAlignedValueChunkData
extends AlignedChunkData {
    public BatchedAlignedValueChunkData(AlignedChunkData alignedChunkData) {
        super(alignedChunkData);
    }

    public BatchedAlignedValueChunkData(IDeviceID device, TTimePartitionSlot timePartitionSlot) {
        super(device, timePartitionSlot);
    }

    @Override
    public void writeDecodeValuePage(long[] times, TsPrimitiveType[] values, TSDataType dataType) throws IOException {
        this.pageNumbers.set(this.pageNumbers.size() - 1, (Integer)this.pageNumbers.get(this.pageNumbers.size() - 1) + 1);
        long startTime = this.timePartitionSlot.getStartTime();
        long endTime = startTime + TimePartitionUtils.getTimePartitionInterval() - 1L;
        if (endTime <= startTime) {
            endTime = Long.MAX_VALUE;
        }
        int satisfiedLength = (Integer)this.satisfiedLengthQueue.poll();
        this.dataSize += (long)ReadWriteIOUtils.write((Boolean)true, (OutputStream)this.stream);
        this.dataSize += (long)ReadWriteIOUtils.write((int)satisfiedLength, (OutputStream)this.stream);
        this.satisfiedLengthQueue.offer(satisfiedLength);
        long pageStartTime = Long.MAX_VALUE;
        long pageEndTime = Long.MIN_VALUE;
        block8: for (int i = 0; i < times.length && times[i] <= endTime; ++i) {
            if (times[i] < startTime) continue;
            if (values.length == 0 || values[i] == null) {
                this.dataSize += (long)ReadWriteIOUtils.write((Boolean)true, (OutputStream)this.stream);
                continue;
            }
            pageStartTime = Math.min(pageStartTime, times[i]);
            pageEndTime = Math.max(pageEndTime, times[i]);
            this.dataSize += (long)ReadWriteIOUtils.write((Boolean)false, (OutputStream)this.stream);
            switch (dataType) {
                case INT32: 
                case DATE: {
                    this.dataSize += (long)ReadWriteIOUtils.write((int)values[i].getInt(), (OutputStream)this.stream);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    this.dataSize += (long)ReadWriteIOUtils.write((long)values[i].getLong(), (OutputStream)this.stream);
                    continue block8;
                }
                case FLOAT: {
                    this.dataSize += (long)ReadWriteIOUtils.write((float)values[i].getFloat(), (OutputStream)this.stream);
                    continue block8;
                }
                case DOUBLE: {
                    this.dataSize += (long)ReadWriteIOUtils.write((double)values[i].getDouble(), (OutputStream)this.stream);
                    continue block8;
                }
                case BOOLEAN: {
                    this.dataSize += (long)ReadWriteIOUtils.write((Boolean)values[i].getBoolean(), (OutputStream)this.stream);
                    continue block8;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    this.dataSize += (long)ReadWriteIOUtils.write((Binary)values[i].getBinary(), (OutputStream)this.stream);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
                }
            }
        }
        this.dataSize += (long)ReadWriteIOUtils.write((long)pageStartTime, (OutputStream)this.stream);
        this.dataSize += (long)ReadWriteIOUtils.write((long)pageEndTime, (OutputStream)this.stream);
    }

    @Override
    protected void writeChunkToWriter(InputStream stream, TsFileIOWriter writer) throws IOException, PageException {
        for (int i = 0; i < this.chunkHeaderList.size(); ++i) {
            ChunkHeader chunkHeader = (ChunkHeader)this.chunkHeaderList.get(i);
            MeasurementSchema measurementSchema = new MeasurementSchema(chunkHeader.getMeasurementID(), chunkHeader.getDataType(), chunkHeader.getEncodingType(), chunkHeader.getCompressionType());
            ValueChunkWriter valueChunkWriter = new ValueChunkWriter(measurementSchema.getMeasurementName(), measurementSchema.getCompressor(), measurementSchema.getType(), measurementSchema.getEncodingType(), measurementSchema.getValueEncoder());
            this.buildValueChunkWriter(stream, chunkHeader, (Integer)this.pageNumbers.get(i), valueChunkWriter);
            valueChunkWriter.writeToFileWriter(writer);
        }
    }

    private void buildValueChunkWriter(InputStream stream, ChunkHeader chunkHeader, int pageNumber, ValueChunkWriter valueChunkWriter) throws IOException, PageException {
        for (int i = 0; i < pageNumber; ++i) {
            boolean needDecode = ReadWriteIOUtils.readBool((InputStream)stream);
            if (!needDecode) {
                PageHeader pageHeader = PageHeader.deserializeFrom((InputStream)stream, (TSDataType)chunkHeader.getDataType(), (boolean)true);
                valueChunkWriter.writePageHeaderAndDataIntoBuff(ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength((InputStream)stream)), pageHeader);
                continue;
            }
            int length = ReadWriteIOUtils.readInt((InputStream)stream);
            block9: for (int j = 0; j < length; ++j) {
                boolean isNull = ReadWriteIOUtils.readBool((InputStream)stream);
                switch (chunkHeader.getDataType()) {
                    case INT32: 
                    case DATE: {
                        int int32Value = isNull ? 0 : ReadWriteIOUtils.readInt((InputStream)stream);
                        valueChunkWriter.write(0L, int32Value, isNull);
                        continue block9;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        long int64Value = isNull ? 0L : ReadWriteIOUtils.readLong((InputStream)stream);
                        valueChunkWriter.write(0L, int64Value, isNull);
                        continue block9;
                    }
                    case FLOAT: {
                        float floatValue = isNull ? 0.0f : ReadWriteIOUtils.readFloat((InputStream)stream);
                        valueChunkWriter.write(0L, floatValue, isNull);
                        continue block9;
                    }
                    case DOUBLE: {
                        double doubleValue = isNull ? 0.0 : ReadWriteIOUtils.readDouble((InputStream)stream);
                        valueChunkWriter.write(0L, doubleValue, isNull);
                        continue block9;
                    }
                    case BOOLEAN: {
                        boolean boolValue = isNull ? false : ReadWriteIOUtils.readBool((InputStream)stream);
                        valueChunkWriter.write(0L, boolValue, isNull);
                        continue block9;
                    }
                    case TEXT: 
                    case BLOB: 
                    case STRING: {
                        Binary binaryValue = isNull ? DEFAULT_BINARY : ReadWriteIOUtils.readBinary((InputStream)stream);
                        valueChunkWriter.write(0L, binaryValue, isNull);
                        continue block9;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", chunkHeader.getDataType()));
                    }
                }
            }
            Statistics statistics = valueChunkWriter.getPageWriter().getStatistics();
            long startTime = ReadWriteIOUtils.readLong((InputStream)stream);
            long endTime = ReadWriteIOUtils.readLong((InputStream)stream);
            statistics.setStartTime(startTime);
            statistics.setEndTime(endTime);
            valueChunkWriter.sealCurrentPage();
        }
    }
}

