/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.DeviceTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OffsetNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Capture;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class PushDownOffsetIntoTableScan
implements Rule<OffsetNode> {
    private static final Capture<TableScanNode> CHILD = Capture.newCapture();
    private static final Pattern<OffsetNode> PATTERN = Patterns.offset().with(Patterns.source().matching(Patterns.tableScan().capturedAs(CHILD)));

    @Override
    public Pattern<OffsetNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(OffsetNode parent, Captures captures, Rule.Context context) {
        TableScanNode tableScanNode = captures.get(CHILD);
        if (tableScanNode instanceof DeviceTableScanNode && !((DeviceTableScanNode)tableScanNode).isPushLimitToEachDevice()) {
            tableScanNode.setPushDownOffset(parent.getCount());
            tableScanNode.setPushDownLimit(tableScanNode.getPushDownLimit() == 0L ? 0L : tableScanNode.getPushDownLimit() - parent.getCount());
            return Rule.Result.ofPlanNode(tableScanNode);
        }
        return Rule.Result.empty();
    }
}

