/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.auth.oauth2.OAuth2CredentialsWithRefresh;
import java.util.Date;
import java.util.Optional;
import org.apache.iceberg.gcp.GCPProperties;
import org.apache.iceberg.gcp.gcs.OAuth2RefreshCredentialsHandler;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public final class GCPAuthUtils {
    private GCPAuthUtils() {
    }

    public static OAuth2Credentials oauth2CredentialsFromGcpProperties(GCPProperties gcpProperties, CloseableGroup closeableGroup) {
        Optional<String> optionalToken = gcpProperties.oauth2Token();
        Preconditions.checkState((boolean)optionalToken.isPresent(), (Object)"OAuth2 token must be set to produce OAuth2 Credentials");
        AccessToken accessToken = new AccessToken(optionalToken.get(), (Date)gcpProperties.oauth2TokenExpiresAt().orElse(null));
        if (gcpProperties.oauth2RefreshCredentialsEnabled() && gcpProperties.oauth2RefreshCredentialsEndpoint().isPresent()) {
            Preconditions.checkNotNull((Object)closeableGroup, (Object)"Must specify a closeable group that handles closure of refresh handler.");
            OAuth2RefreshCredentialsHandler oAuthRefreshHandler = OAuth2RefreshCredentialsHandler.create(gcpProperties.properties());
            closeableGroup.addCloseable((AutoCloseable)oAuthRefreshHandler);
            return OAuth2CredentialsWithRefresh.newBuilder().setAccessToken(accessToken).setRefreshHandler((OAuth2CredentialsWithRefresh.OAuth2RefreshHandler)oAuthRefreshHandler).build();
        }
        return OAuth2Credentials.create((AccessToken)accessToken);
    }
}

