/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.GenericPartitionStatisticsFile;
import org.apache.iceberg.PartitionStatisticsFile;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GenericPartitionStatisticsFile", generator="Immutables")
@Immutable
public final class ImmutableGenericPartitionStatisticsFile
implements GenericPartitionStatisticsFile {
    private final long snapshotId;
    private final String path;
    private final long fileSizeInBytes;

    private ImmutableGenericPartitionStatisticsFile(long snapshotId, String path, long fileSizeInBytes) {
        this.snapshotId = snapshotId;
        this.path = path;
        this.fileSizeInBytes = fileSizeInBytes;
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public String path() {
        return this.path;
    }

    public long fileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public final ImmutableGenericPartitionStatisticsFile withSnapshotId(long value) {
        if (this.snapshotId == value) {
            return this;
        }
        return new ImmutableGenericPartitionStatisticsFile(value, this.path, this.fileSizeInBytes);
    }

    public final ImmutableGenericPartitionStatisticsFile withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableGenericPartitionStatisticsFile(this.snapshotId, newValue, this.fileSizeInBytes);
    }

    public final ImmutableGenericPartitionStatisticsFile withFileSizeInBytes(long value) {
        if (this.fileSizeInBytes == value) {
            return this;
        }
        return new ImmutableGenericPartitionStatisticsFile(this.snapshotId, this.path, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGenericPartitionStatisticsFile && this.equalsByValue((ImmutableGenericPartitionStatisticsFile)another);
    }

    private boolean equalsByValue(ImmutableGenericPartitionStatisticsFile another) {
        return this.snapshotId == another.snapshotId && this.path.equals(another.path) && this.fileSizeInBytes == another.fileSizeInBytes;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.snapshotId);
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + Long.hashCode(this.fileSizeInBytes);
        return h;
    }

    public String toString() {
        return "GenericPartitionStatisticsFile{snapshotId=" + this.snapshotId + ", path=" + this.path + ", fileSizeInBytes=" + this.fileSizeInBytes + "}";
    }

    public static ImmutableGenericPartitionStatisticsFile copyOf(GenericPartitionStatisticsFile instance) {
        if (instance instanceof ImmutableGenericPartitionStatisticsFile) {
            return (ImmutableGenericPartitionStatisticsFile)instance;
        }
        return ImmutableGenericPartitionStatisticsFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GenericPartitionStatisticsFile", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SNAPSHOT_ID = 1L;
        private static final long INIT_BIT_PATH = 2L;
        private static final long INIT_BIT_FILE_SIZE_IN_BYTES = 4L;
        private long initBits = 7L;
        private long snapshotId;
        @Nullable
        private String path;
        private long fileSizeInBytes;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PartitionStatisticsFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(GenericPartitionStatisticsFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            PartitionStatisticsFile instance;
            long bits = 0L;
            if (object instanceof PartitionStatisticsFile) {
                instance = (PartitionStatisticsFile)object;
                if ((bits & 2L) == 0L) {
                    this.path(instance.path());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.fileSizeInBytes(instance.fileSizeInBytes());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.snapshotId(instance.snapshotId());
                    bits |= 1L;
                }
            }
            if (object instanceof GenericPartitionStatisticsFile) {
                instance = (GenericPartitionStatisticsFile)object;
                if ((bits & 2L) == 0L) {
                    this.path(instance.path());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.fileSizeInBytes(instance.fileSizeInBytes());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.snapshotId(instance.snapshotId());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder snapshotId(long snapshotId) {
            this.snapshotId = snapshotId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fileSizeInBytes(long fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGenericPartitionStatisticsFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGenericPartitionStatisticsFile(this.snapshotId, this.path, this.fileSizeInBytes);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("snapshotId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("fileSizeInBytes");
            }
            return "Cannot build GenericPartitionStatisticsFile, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

