/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Collection;
import org.apache.iceberg.PendingUpdate;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;

public interface UpdateSchema
extends PendingUpdate<Schema> {
    public UpdateSchema allowIncompatibleChanges();

    default public UpdateSchema addColumn(String name, Type type) {
        return this.addColumn(name, type, null, null);
    }

    default public UpdateSchema addColumn(String name, Type type, String doc) {
        return this.addColumn(name, type, doc, null);
    }

    default public UpdateSchema addColumn(String name, Type type, Literal<?> defaultValue) {
        return this.addColumn(name, type, null, defaultValue);
    }

    default public UpdateSchema addColumn(String name, Type type, String doc, Literal<?> defaultValue) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0, (String)"Cannot add column with ambiguous name: %s, use addColumn(parent, name, type)", (Object)name);
        return this.addColumn(null, name, type, doc, defaultValue);
    }

    default public UpdateSchema addColumn(String parent, String name, Type type) {
        return this.addColumn(parent, name, type, null, null);
    }

    default public UpdateSchema addColumn(String parent, String name, Type type, String doc) {
        return this.addColumn(parent, name, type, doc, null);
    }

    default public UpdateSchema addColumn(String parent, String name, Type type, Literal<?> defaultValue) {
        return this.addColumn(parent, name, type, null, defaultValue);
    }

    default public UpdateSchema addColumn(String parent, String name, Type type, String doc, Literal<?> defaultValue) {
        throw new UnsupportedOperationException("Default values are not supported");
    }

    default public UpdateSchema addRequiredColumn(String name, Type type) {
        return this.addRequiredColumn(name, type, null, null);
    }

    default public UpdateSchema addRequiredColumn(String name, Type type, String doc) {
        return this.addRequiredColumn(name, type, doc, null);
    }

    default public UpdateSchema addRequiredColumn(String name, Type type, Literal<?> defaultValue) {
        return this.addRequiredColumn(name, type, null, defaultValue);
    }

    default public UpdateSchema addRequiredColumn(String name, Type type, String doc, Literal<?> defaultValue) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0, (String)"Cannot add column with ambiguous name: %s, use addColumn(parent, name, type)", (Object)name);
        return this.addRequiredColumn(null, name, type, doc, defaultValue);
    }

    default public UpdateSchema addRequiredColumn(String parent, String name, Type type) {
        return this.addRequiredColumn(parent, name, type, null, null);
    }

    default public UpdateSchema addRequiredColumn(String parent, String name, Type type, String doc) {
        return this.addRequiredColumn(parent, name, type, doc, null);
    }

    default public UpdateSchema addRequiredColumn(String parent, String name, Type type, Literal<?> defaultValue) {
        return this.addRequiredColumn(parent, name, type, null, defaultValue);
    }

    default public UpdateSchema addRequiredColumn(String parent, String name, Type type, String doc, Literal<?> defaultValue) {
        throw new UnsupportedOperationException("Default values are not supported");
    }

    public UpdateSchema renameColumn(String var1, String var2);

    public UpdateSchema updateColumn(String var1, Type.PrimitiveType var2);

    default public UpdateSchema updateColumn(String name, Type.PrimitiveType newType, String newDoc) {
        return this.updateColumn(name, newType).updateColumnDoc(name, newDoc);
    }

    public UpdateSchema updateColumnDoc(String var1, String var2);

    default public UpdateSchema updateColumnDefault(String name, Literal<?> newDefault) {
        throw new UnsupportedOperationException("Default values are not supported");
    }

    public UpdateSchema makeColumnOptional(String var1);

    public UpdateSchema requireColumn(String var1);

    public UpdateSchema deleteColumn(String var1);

    public UpdateSchema moveFirst(String var1);

    public UpdateSchema moveBefore(String var1, String var2);

    public UpdateSchema moveAfter(String var1, String var2);

    public UpdateSchema unionByNameWith(Schema var1);

    public UpdateSchema setIdentifierFields(Collection<String> var1);

    default public UpdateSchema setIdentifierFields(String ... names) {
        return this.setIdentifierFields(Sets.newHashSet((Object[])names));
    }

    default public UpdateSchema caseSensitive(boolean caseSensitive) {
        throw new UnsupportedOperationException();
    }
}

