/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.aws;

import jakarta.annotation.Nonnull;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.polaris.core.storage.StorageLocation;

public class S3Location
extends StorageLocation {
    private static final Pattern URI_PATTERN = Pattern.compile("^(s3a?):(.+)$");
    private final String scheme;
    private final String locationWithoutScheme;

    public S3Location(@Nonnull String location) {
        super(location);
        Matcher matcher = URI_PATTERN.matcher(location);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid S3 location uri " + location);
        }
        this.scheme = matcher.group(1);
        this.locationWithoutScheme = matcher.group(2);
    }

    public static boolean isS3Location(String location) {
        if (location == null) {
            return false;
        }
        Matcher matcher = URI_PATTERN.matcher(location);
        return matcher.matches();
    }

    @Override
    public boolean isChildOf(StorageLocation potentialParent) {
        if (potentialParent instanceof S3Location) {
            S3Location that = (S3Location)potentialParent;
            String slashTerminatedObjectKey = S3Location.ensureTrailingSlash(this.locationWithoutScheme);
            String slashTerminatedObjectKeyThat = S3Location.ensureTrailingSlash(that.locationWithoutScheme);
            return slashTerminatedObjectKey.startsWith(slashTerminatedObjectKeyThat);
        }
        return false;
    }

    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String withoutScheme() {
        return this.locationWithoutScheme;
    }
}

