/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.constants;

public enum DNSOperationCode {
    Query("Query", 0),
    IQuery("Inverse Query", 1),
    Status("Status", 2),
    Unassigned("Unassigned", 3),
    Notify("Notify", 4),
    Update("Update", 5);

    static final int OpCode_MASK = 30720;
    private final String externalName;
    private final int indexValue;

    private DNSOperationCode(String name, int index) {
        this.externalName = name;
        this.indexValue = index;
    }

    public String externalName() {
        return this.externalName;
    }

    public int indexValue() {
        return this.indexValue;
    }

    public static DNSOperationCode operationCodeForFlags(int flags) {
        int maskedIndex = (flags & 0x7800) >> 11;
        for (DNSOperationCode operationCode : DNSOperationCode.values()) {
            if (operationCode.indexValue != maskedIndex) continue;
            return operationCode;
        }
        return Unassigned;
    }

    public String toString() {
        return this.name() + " index " + this.indexValue();
    }
}

