/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.spi.Metadata;
import org.slf4j.Logger;

@Metadata(label="eip,routing", title="Logger")
@XmlRootElement(name="log")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LogDefinition
extends NoOutputDefinition<LogDefinition> {
    @XmlTransient
    private Logger loggerBean;
    @XmlAttribute(required=true)
    private String message;
    @XmlAttribute
    @Metadata(javaType="org.apache.camel.LoggingLevel", defaultValue="INFO", enums="TRACE,DEBUG,INFO,WARN,ERROR,OFF")
    private String loggingLevel;
    @XmlAttribute
    private String logName;
    @XmlAttribute
    @Metadata(label="advanced")
    private String marker;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.slf4j.Logger")
    private String logger;
    @XmlAttribute
    @Metadata(label="advanced")
    private String logLanguage;

    public LogDefinition() {
    }

    protected LogDefinition(LogDefinition source) {
        super(source);
        this.loggerBean = source.loggerBean;
        this.message = source.message;
        this.loggingLevel = source.loggingLevel;
        this.logName = source.logName;
        this.marker = source.marker;
        this.logger = source.logger;
    }

    public LogDefinition(String message) {
        this();
        this.message = message;
    }

    @Override
    public LogDefinition copyDefinition() {
        return new LogDefinition(this);
    }

    public String toString() {
        return "Log[" + this.message + "]";
    }

    public String getShortName() {
        return "log";
    }

    @Override
    public String getLabel() {
        return "log";
    }

    public Logger getLoggerBean() {
        return this.loggerBean;
    }

    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public void setLogger(Logger logger) {
        this.loggerBean = logger;
    }

    public String getLogger() {
        return this.logger;
    }

    public String getLogLanguage() {
        return this.logLanguage;
    }

    public void setLogLanguage(String logLanguage) {
        this.logLanguage = logLanguage;
    }
}

